﻿//============================================
// filename: main.c
// chip    : CSU38F20
// author  :
// date    : 2020-12-07
//============================================
#include "CSU38F20.h"
#include "adc.h"
#include "isp.h"
#include "uart.h"
#include "timer0.h"

unsigned char systime_cnt = 0;
unsigned char systime_flag = 0;
unsigned int adc_samp_result = 0;
unsigned char uart_trans_1byte_ok = 1;
unsigned char temp = 0;
//============================================
// interrupt function
//============================================
void INT_FUNCTION(void) interrupt
{
	if(TM0IF && TM0IE)
	{
		TM0IF = 0;
		if(++systime_cnt >= 100)
		{
			systime_cnt = 0;
			systime_flag = 1;
		}
	}
	else if(UR0IF)
	{
		if(UR0_TEIF && UR0_TEIE)		//发送中断表示发送FIFO数据已取走为空，可向其写入数据，但串口仍处于发送数据状态，需判断TX_BUSY为0方可进入休眠
		{
			UR0_TEIF = 0;
			uart_trans_1byte_ok = 1;
		}
		else if(UR0_RNIF && UR0_RNIE)	//接收FIFO非空中断
		{
			temp = UR0_RX_REG;
		}
		else if(UR0_RHIF && UR0_RHIE)	//接收FIFO半满中断，共有8级接收FIFO，数据长度大于等于4时中断标志位置起
		{
			UR0_RHIF = 0;
		}
		else if(UR0WK_IF && UR0WK_IE)	//串口接收唤醒中断，唤醒后建议查询RX_BUSY位，若为0则唤醒可能是由于干扰造成
		{
			UR0WK_IF = 0;
		}
		else if(UR0ERRIF && UR0ERRIE)	//接收错误标志位，不可直接清零，在查询并清除RX_OV_ERR、STOP_ERR标志位后自动清零
		{
			if(RX_OV_ERR)
			{
				RX_OV_ERR = 0;
			}
			if(STOP_ERR)
			{
				STOP_ERR = 0;
			}
		}
	}
}

//============================================
// program start
//============================================
void main()
{
	PT3CON_0 = 1;
	PT5EN_3 = 1;
	PT3EN_3 = 0;	//PT3.3为模拟输入口
	PT3PU_3 = 0;
	PT3CON_3 = 1;
	timer0_init();
	adc_init();
	uart_init();		//波特率为38400，PT5.2为RX，PT5.3为TX
	while(1)
	{
		adc_samp_result = adc_get_result(SIG_VREF);
//		adc_samp_result = 0x0795;
		if(systime_flag)
		{
			systime_flag = 0;
			uart();
		}	
	}
}
